/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class SigningCertMgtBean
extends PanelBean
implements CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTSCBD";
    private static final String TRACE_MASKF = "XCRTSCBF";
    private static final String TRACE_MASKT = "XCRTSCBT";
    private ServerCert certificate = null;
    private ItemDescriptor[][] m_idSigningCertTable;
    private ColumnDescriptor[] m_cdSigningCertTableStructure;
    private int[] m_iSigningCertTableSelection;
    private String m_sSigningCertLabel;

    public SigningCertMgtBean(ServerCert certificate, String name) {
        this.certificate = certificate;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->SigningCertMgtBean(" + certificate + ", " + name + ")");
    }

    public void setSigningCertLabel(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setSigningCertLabel(" + s + ")");
        this.m_sSigningCertLabel = s;
    }

    public String getSigningCertLabel() {
        Trace.trace(TRACE_MASKT, "<->getSigningCertLabel() returning " + this.m_sSigningCertLabel);
        return this.m_sSigningCertLabel;
    }

    public void setSigningCertTableSelection(int[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setSigningCertTableSelection(...)");
        this.m_iSigningCertTableSelection = selected;
    }

    public int[] getSigningCertTableSelection() {
        Trace.trace(TRACE_MASKT, "<->getSigningCertTableSelection() returning " + this.m_iSigningCertTableSelection);
        return this.m_iSigningCertTableSelection;
    }

    public void setSigningCertTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setSigningCertTableRowAt(" + index + ", ...)");
        this.m_idSigningCertTable[index] = items;
    }

    public ItemDescriptor[] getSigningCertTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "<->getSigningCertTableRowAt(" + index + ") returning " + this.m_idSigningCertTable[index]);
        return this.m_idSigningCertTable[index];
    }

    public int getSigningCertTableRowCount() {
        if (this.certificate == null) {
            return 0;
        }
        return 7;
    }

    public int getSigningCertTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getSigningCertTableRowStructure() {
        return this.m_cdSigningCertTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "<->load()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "->prepare()");
        this.initializeTable(this.getUserTaskManager());
        Trace.trace(TRACE_MASKT, "<-prepare()");
    }

    public void save() {
    }

    private void initializeTable(UserTaskManager utm) {
        if (this.certificate == null) {
            this.setSigningCertLabel(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "signingCertLabelWhenNone").toString());
            if (utm != null) {
                utm.setShown(this.getMountPrefix() + "SigningCertTable", false);
            }
            this.m_idSigningCertTable = new ItemDescriptor[0][0];
        } else {
            this.setSigningCertLabel(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "signingCertLabel").toString());
            if (utm != null) {
                utm.setShown(this.getMountPrefix() + "SigningCertTable", true);
            }
            this.m_idSigningCertTable = CertMgtPanelUtils.createCertTable(this.certificate, false);
        }
        this.m_cdSigningCertTableStructure = new ColumnDescriptor[0];
        this.m_iSigningCertTableSelection = new int[0];
    }

    public void panelAction(TaskActionEvent event) {
        String elementName = null;
        String actionCommand = null;
        UserTaskManager utm = null;
        Trace.trace(TRACE_MASKT, "->panelAction(" + event + ")");
        if (event != null) {
            Trace.trace(TRACE_MASKF, "Bean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
            elementName = event.getElementName();
            actionCommand = event.getActionCommand();
            if (actionCommand.equals("SigningCertActionsMenu.ViewSigningCertificateMenuItem")) {
                utm = this.getUserTaskManager();
                if (utm != null) {
                    utm.storeAllElements();
                }
                CertMgtPanelUtils.sendTaskletRequest("AdvancedMenu.ViewSigningCertificateMenuItem", null, this);
            } else if (elementName.equals("CloseButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }
}

